/*
 * Decompiled with CFR 0.152.
 */
package com.android.product.data.repository;

import com.android.core.data.AndroidRepository;
import com.android.core.utils.params.QueryParamTypes;
import com.android.product.data.repository.ProductRepository;
import com.android.product.domain.mapper.ProductRowMapper;
import com.android.product.domain.model.ProductDto;
import com.service.SettingLoader;
import com.utility.DbConnection;
import com.utility.Paging;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
public class ProductRepository
extends AndroidRepository<ProductDto> {
    @Autowired
    public ProductRepository(DbConnection dbConnection) {
        super(dbConnection);
    }

    @NotNull
    protected QueryParamTypes queryParamType() {
        return QueryParamTypes.ARTICLE;
    }

    protected RowMapper<ProductDto> getRowMapper() {
        return new ProductRowMapper();
    }

    protected Paging.PageSqlData queryWithDefaultPaging(SettingLoader settingsLoader) {
        if (settingsLoader.sendProductsDisabled()) {
            return null;
        }
        QueryBuilder query = new QueryBuilder(settingsLoader);
        return Paging.PageSqlData.builder().selectSqlStr(query.getSelectPart()).whereStr(query.getWherePart()).joinsStr(query.getJoinsPart()).alias("A").keyField("[code]").keyFieldType("nvarchar(7)").build();
    }
}

